/** chess_pgn_limos( +Pgn, -Limos ).

Limos are all the long integer positions structures, generated by a (single) PGN game term.

Each =|Limo = limo(Ply,Hmv,Mv,Inpo)|=, where Ply, Hmv and Mv are of the current position where Inpo
is the the numerical representation of the move's parent position.

==
?- pgn( pgn('4ncl_short'), [PgnGame1|_] ), chess_pgn_limos( PgnGame1, Inpos ).
PgnGame1 = pgn(['Event'-'4NCL Division 1a', 'Site'-'Telford, ENG', 'Date'-'2017.11.11', 'Round'-'1.11', 'White'-'Sadler, Matthew D', 'Black'-'Wheeler, Darren P', 'Result'-'1-0', ... - ...|...], [move(1, e4, e6, '', ''), move(2, d3, d5, '', ''), move(3, 'Nd2', 'Nf6', '', ''), move(4, e5, 'Nfd7', '', ''), move(5, f4, b6, '', ''), move(6, g3, c5, '', ''), move(7, 'Bg2', 'Bb7', '', ''), move(..., ..., ..., ..., ...)|...], '1-0', [[91, 69, 118, 101, 110, 116, 32|...], [91, 83, 105, 116, 101, 32|...], [91, 68, 97, 116, 101|...], [91, 82, 111, 117|...], [91, 87, 104|...], [91, 66|...], [91|...], [...|...]|...]),
Inpos = [limo(0, 0, e4, 100700000000010408070000000001020907000000000103120700000000010611070000000001050907000000000103080700000000010210070000000001040030), limo(1, 0, e6, 100700000000010408070000000001020907000000000103120700000100000611070000000001050907000000000103080700000000010210070000000001003731), limo(2, 0, d3, 100700000000010408070000000001020907000000000103120007000100000611070000000001050907000000000103080700000000010210070000000001040030), limo(3, 0, d5, 100700000000010408070000000001020907000000000103120007000100000611070000000100050907000000000103080700000000010210070000000001040031), limo(4, 0, 'Nd2', 100700000000010408070000000001020907000000000103120007000100000611000007000100050907000000000103080700000000010210070000000001003230), limo(5, 1, 'Nf6', 100700000000010408070000000001020907000000000103120007000100000611000007000102050907000000000103080700000000010010070000000001040031), limo(6, 2, e5, 100700000000010400070000000001020907080000000103120007000100000611000007000102050907000000000103080700000000010010070000000001040030), limo(7, 0, 'Nfd7', 100700000000010400070000000001020907080000000103120007010000000611000007000102050907000000000103080700000000010010070000000001040031), limo(..., ..., ..., ...)|...].
==

@author nicos angelopoulos
@version  0:1 2020/3/27

*/

chess_pgn_limos( Pgn, Limos ) :-
    Pgn = pgn(_Info,Moves,_Res,_Text),
    chess_dict_start_board( Start ),
    chess_pgn_moves_limos( Moves, 1, Start, Limos ).

chess_pgn_moves_limos( [], Ply, Board, Limo ) :-
    chess_dict_inpo( Board, Inpo ),
    Limo = [limo(Ply,Board.hmv,[],Inpo)].
chess_pgn_moves_limos( [move(_, WhMv, BlMv,_,_)|T], Ply, Board, Limos ) :-
    debug( chess_db(limo), 'Move, white: ~w, black: ~w', [WhMv,BlMv] ),
    chess_dict_inpo( Board, WhInpo ),
    Bly is Ply + 1,
    % ( WhMv == 'R8d7' -> trace; true ),
    chess_dict_move( WhMv, Board, fail, Woard ),
    Wimo = limo(Ply,Woard.hmv,WhMv,WhInpo),
    ( BlMv == [] ->
        Fly is Bly, Noard = Woard,
        Limos = [Wimo|Timos]
        ;
        chess_dict_inpo( Woard, BlInpo ),
        chess_dict_move( BlMv, Woard, fail, Noard ),
        Bimo = limo(Bly,Noard.hmv,BlMv,BlInpo),
        Limos = [Wimo,Bimo|Timos],
        Fly is Bly + 1
    ),
    chess_pgn_moves_limos( T, Fly, Noard, Timos ).

/*
chess_pgn_inpos( Pgn, Inpos ) :-
    Pgn = pgn(_Info,Moves,_Res,_Text),
    chess_dict_start_board( Start ),
    chess_moves_game_plys( Moves, Game ),
    chess_dict_game_play( Game, Start, Boards ),
    maplist( chess_dict_inpo, Boards, Inpos ).
chess_dict_game_play( [], _Board, [] ).
chess_dict_game_play( [Mv-Turn|T], Board, [Coard|Dicts] ) :-
    chess_dict_move( Mv, Board, Turn, Coard ),
    chess_dict_game_play( T, Coard, Dicts ).

chess_moves_game_plys( [], [] ).
chess_moves_game_plys( [move(_,White,BlackPrv,_,_)|T], [White-0|R] ) :-
    ( BlackPrv == [] ->    % T should be [] too.... fixme:
        R = M
        ;
        R = [BlackPrv-1|M]
    ),
    chess_moves_game_plys( T, M ).
    */
