/** latex_colour( ?FullName, -HexString, ?CodingName, -RGBterm ).

This is a prolog facts base of the site latexolor.com .

==
?- latex_colour( _, Hex, apricot, RGB ).
Hex = "#FBCEB1",
RGB = rgb(0.98, 0.81, 0.69).
==

@author nicos angelopoulos
@version  0.1 2022/12/16
@see colour_hex/2
@see https://latexcolor.com/
@see http://en.wikipedia.org/wiki/List_of_colors
@license Creative Commons (see links above).

*/
latex_colour('Air Force blue', "#5D8AA8", airforceblue, rgb(0.36, 0.54, 0.66)).
latex_colour('Alice blue', "#F0F8FF", aliceblue, rgb(0.94, 0.97, 1.0)).
latex_colour('Alizarin', "#E32636", alizarin, rgb(0.82, 0.1, 0.26)).
latex_colour('Almond', "#EFDECD", almond, rgb(0.94, 0.87, 0.8)).
latex_colour('Amaranth', "#E52B50", amaranth, rgb(0.9, 0.17, 0.31)).
latex_colour('Amber', "#FFBF00", amber, rgb(1.0, 0.75, 0.0)).
latex_colour('Amber (SAE/ECE)', "#FF7E00", 'amber(sae/ece)', rgb(1.0, 0.49, 0.0)).
latex_colour('American rose', "#FF033E", americanrose, rgb(1.0, 0.01, 0.24)).
latex_colour('Amethyst', "#9966CC", amethyst, rgb(0.6, 0.4, 0.8)).
latex_colour('Anti-flash white', "#F2F3F4", 'anti-flashwhite', rgb(0.95, 0.95, 0.96)).
latex_colour('Antique brass', "#CD9575", antiquebrass, rgb(0.8, 0.58, 0.46)).
latex_colour('Antique fuchsia', "#915C83", antiquefuchsia, rgb(0.57, 0.36, 0.51)).
latex_colour('Antique white', "#FAEBD7", antiquewhite, rgb(0.98, 0.92, 0.84)).
latex_colour('Ao', "#0000FF", ao, rgb(0.0, 0.0, 1.0)).
latex_colour('Ao (English)', "#008000", 'ao(english)', rgb(0.0, 0.5, 0.0)).
latex_colour('Apple green', "#8DB600", applegreen, rgb(0.55, 0.71, 0.0)).
latex_colour('Apricot', "#FBCEB1", apricot, rgb(0.98, 0.81, 0.69)).
latex_colour('Aqua', "#00FFFF", aqua, rgb(0.0, 1.0, 1.0)).
latex_colour('Aquamarine', "#7FFFD0", aquamarine, rgb(0.5, 1.0, 0.83)).
latex_colour('Army green', "#4B5320", armygreen, rgb(0.29, 0.33, 0.13)).
latex_colour('Arsenic', "#3B444B", arsenic, rgb(0.23, 0.27, 0.29)).
latex_colour('Arylide yellow', "#E9D66B", arylideyellow, rgb(0.91, 0.84, 0.42)).
latex_colour('Ash grey', "#B2BEB5", ashgrey, rgb(0.7, 0.75, 0.71)).
latex_colour('Asparagus', "#87A96B", asparagus, rgb(0.53, 0.66, 0.42)).
latex_colour('Atomic tangerine', "#FF9966", atomictangerine, rgb(1.0, 0.6, 0.4)).
latex_colour('Auburn', "#6D351A", auburn, rgb(0.43, 0.21, 0.1)).
latex_colour('Aureolin', "#FDEE00", aureolin, rgb(0.99, 0.93, 0.0)).
latex_colour('AuroMetalSaurus', "#6E7F80", aurometalsaurus, rgb(0.43, 0.5, 0.5)).
latex_colour('Awesome', "#FF2052", awesome, rgb(1.0, 0.13, 0.32)).
latex_colour('Azure (color wheel)', "#007FFF", 'azure(colorwheel)', rgb(0.0, 0.5, 1.0)).
latex_colour('Azure (web) (Azure mist)', "#F0FFFF", 'azure(web)(azuremist)', rgb(0.94, 1.0, 1.0)).
latex_colour('Baby blue', "#89CFF0", babyblue, rgb(0.54, 0.81, 0.94)).
latex_colour('Baby blue eyes', "#A1CAF1", babyblueeyes, rgb(0.63, 0.79, 0.95)).
latex_colour('Baby pink', "#F4C2C2", babypink, rgb(0.96, 0.76, 0.76)).
latex_colour('Ball Blue', "#21ABCD", ballblue, rgb(0.13, 0.67, 0.8)).
latex_colour('Banana Mania', "#FAE7B5", bananamania, rgb(0.98, 0.91, 0.71)).
latex_colour('Banana Yellow', "#FFE135", bananayellow, rgb(1.0, 0.88, 0.21)).
latex_colour('Battleship grey', "#848482", battleshipgrey, rgb(0.52, 0.52, 0.51)).
latex_colour('Bazaar', "#98777B", bazaar, rgb(0.6, 0.47, 0.48)).
latex_colour('Beau blue', "#BCD4E6", beaublue, rgb(0.74, 0.83, 0.9)).
latex_colour('Beaver', "#9F8170", beaver, rgb(0.62, 0.51, 0.44)).
latex_colour('Beige', "#F5F5DC", beige, rgb(0.96, 0.96, 0.86)).
latex_colour('Bisque', "#FFE4C4", bisque, rgb(1.0, 0.89, 0.77)).
latex_colour('Bistre', "#3D2B1F", bistre, rgb(0.24, 0.17, 0.12)).
latex_colour('Bittersweet', "#FE6F5E", bittersweet, rgb(1.0, 0.44, 0.37)).
latex_colour('Black', "#000000", black, rgb(0.0, 0.0, 0.0)).
latex_colour('Blanched Almond', "#FFEBCD", blanchedalmond, rgb(1.0, 0.92, 0.8)).
latex_colour('Bleu de France', "#318CE7", bleudefrance, rgb(0.19, 0.55, 0.91)).
latex_colour('Blizzard Blue', "#ACE5EE", blizzardblue, rgb(0.67, 0.9, 0.93)).
latex_colour('Blond', "#FAF0BE", blond, rgb(0.98, 0.94, 0.75)).
latex_colour('Blue', "#0000FF", blue, rgb(0.0, 0.0, 1.0)).
latex_colour('Blue (Munsell)', "#0093AF", 'blue(munsell)', rgb(0.0, 0.5, 0.69)).
latex_colour('Blue (NCS)', "#0087BD", 'blue(ncs)', rgb(0.0, 0.53, 0.74)).
latex_colour('Blue (pigment)', "#333399", 'blue(pigment)', rgb(0.2, 0.2, 0.6)).
latex_colour('Blue (RYB)', "#0247FE", 'blue(ryb)', rgb(0.01, 0.28, 1.0)).
latex_colour('Blue Bell', "#A2A2D0", bluebell, rgb(0.64, 0.64, 0.82)).
latex_colour('Blue Gray', "#6699CC", bluegray, rgb(0.4, 0.6, 0.8)).
latex_colour('Blue-green', "#00DDDD", 'blue-green', rgb(0.0, 0.87, 0.87)).
latex_colour('Blue-violet', "#8A2BE2", 'blue-violet', rgb(0.54, 0.17, 0.89)).
latex_colour('Blush', "#DE5D83", blush, rgb(0.87, 0.36, 0.51)).
latex_colour('Bole', "#79443B", bole, rgb(0.47, 0.27, 0.23)).
latex_colour('Bondi blue', "#0095B6", bondiblue, rgb(0.0, 0.58, 0.71)).
latex_colour('Boston University Red', "#CC0000", bostonuniversityred, rgb(0.8, 0.0, 0.0)).
latex_colour('Brandeis blue', "#0070FF", brandeisblue, rgb(0.0, 0.44, 1.0)).
latex_colour('Brass', "#B5A642", brass, rgb(0.71, 0.65, 0.26)).
latex_colour('Brick red', "#CB4154", brickred, rgb(0.8, 0.25, 0.33)).
latex_colour('Bright cerulean', "#1DACD6", brightcerulean, rgb(0.11, 0.67, 0.84)).
latex_colour('Bright green', "#66FF00", brightgreen, rgb(0.4, 1.0, 0.0)).
latex_colour('Bright lavender', "#BF94E4", brightlavender, rgb(0.75, 0.58, 0.89)).
latex_colour('Bright maroon', "#C32148", brightmaroon, rgb(0.76, 0.13, 0.28)).
latex_colour('Bright pink', "#FF007F", brightpink, rgb(1.0, 0.0, 0.5)).
latex_colour('Bright turquoise', "#08E8DE", brightturquoise, rgb(0.03, 0.91, 0.87)).
latex_colour('Bright ube', "#D19FE8", brightube, rgb(0.82, 0.62, 0.91)).
latex_colour('Brilliant lavender', "#F4BBFF", brilliantlavender, rgb(0.96, 0.73, 1.0)).
latex_colour('Brilliant rose', "#FF55A3", brilliantrose, rgb(1.0, 0.33, 0.64)).
latex_colour('Brink pink', "#FB607F", brinkpink, rgb(0.98, 0.38, 0.5)).
latex_colour('British racing green', "#004225", britishracinggreen, rgb(0.0, 0.26, 0.15)).
latex_colour('Bronze', "#CD7F32", bronze, rgb(0.8, 0.5, 0.2)).
latex_colour('Brown (traditional)', "#964B00", 'brown(traditional)', rgb(0.59, 0.29, 0.0)).
latex_colour('Brown (web)', "#A52A2A", 'brown(web)', rgb(0.65, 0.16, 0.16)).
latex_colour('Bubble gum', "#FFC1CC", bubblegum, rgb(0.99, 0.76, 0.8)).
latex_colour('Bubbles', "#E7FEFF", bubbles, rgb(0.91, 1.0, 1.0)).
latex_colour('Buff', "#F0DC82", buff, rgb(0.94, 0.86, 0.51)).
latex_colour('Bulgarian rose', "#480607", bulgarianrose, rgb(0.28, 0.02, 0.03)).
latex_colour('Burgundy', "#800020", burgundy, rgb(0.5, 0.0, 0.13)).
latex_colour('Burlywood', "#DEB887", burlywood, rgb(0.87, 0.72, 0.53)).
latex_colour('Burnt orange', "#CC5500", burntorange, rgb(0.8, 0.33, 0.0)).
latex_colour('Burnt sienna', "#E97451", burntsienna, rgb(0.91, 0.45, 0.32)).
latex_colour('Burnt umber', "#8A3324", burntumber, rgb(0.54, 0.2, 0.14)).
latex_colour('Byzantine', "#BD33A4", byzantine, rgb(0.74, 0.2, 0.64)).
latex_colour('Byzantium', "#702963", byzantium, rgb(0.44, 0.16, 0.39)).
latex_colour('Cadet', "#536872", cadet, rgb(0.33, 0.41, 0.47)).
latex_colour('Cadet blue', "#5F9EA0", cadetblue, rgb(0.37, 0.62, 0.63)).
latex_colour('Cadet grey', "#91A3B0", cadetgrey, rgb(0.57, 0.64, 0.69)).
latex_colour('Cadmium Green', "#006B3C", cadmiumgreen, rgb(0.0, 0.42, 0.24)).
latex_colour('Cadmium Orange', "#ED872D", cadmiumorange, rgb(0.93, 0.53, 0.18)).
latex_colour('Cadmium Red', "#E30022", cadmiumred, rgb(0.89, 0.0, 0.13)).
latex_colour('Cadmium Yellow', "#FFF600", cadmiumyellow, rgb(1.0, 0.96, 0.0)).
latex_colour('Cal Poly Pomona green', "#1E4D2B", calpolypomonagreen, rgb(0.12, 0.3, 0.17)).
latex_colour('Cambridge Blue', "#A3C1AD", cambridgeblue, rgb(0.64, 0.76, 0.68)).
latex_colour('Camel', "#C19A6B", camel, rgb(0.76, 0.6, 0.42)).
latex_colour('Camouflage green', "#78866B", camouflagegreen, rgb(0.47, 0.53, 0.42)).
latex_colour('Canary yellow', "#FFEF00", canaryyellow, rgb(1.0, 0.94, 0.0)).
latex_colour('Candy apple red', "#FF0800", candyapplered, rgb(1.0, 0.03, 0.0)).
latex_colour('Candy pink', "#E4717A", candypink, rgb(0.89, 0.44, 0.48)).
latex_colour('Capri', "#00BFFF", capri, rgb(0.0, 0.75, 1.0)).
latex_colour('Caput mortuum', "#592720", caputmortuum, rgb(0.35, 0.15, 0.13)).
latex_colour('Cardinal', "#C41E3A", cardinal, rgb(0.77, 0.12, 0.23)).
latex_colour('Caribbean green', "#00CC99", caribbeangreen, rgb(0.0, 0.8, 0.6)).
latex_colour('Carmine', "#960018", carmine, rgb(0.59, 0.0, 0.09)).
latex_colour('Carmine pink', "#EB4C42", carminepink, rgb(0.92, 0.3, 0.26)).
latex_colour('Carmine red', "#FF0038", carminered, rgb(1.0, 0.0, 0.22)).
latex_colour('Carnation pink', "#FFA6C9", carnationpink, rgb(1.0, 0.65, 0.79)).
latex_colour('Carnelian', "#B31B1B", carnelian, rgb(0.7, 0.11, 0.11)).
latex_colour('Carolina blue', "#99BADD", carolinablue, rgb(0.6, 0.73, 0.89)).
latex_colour('Carrot orange', "#ED9121", carrotorange, rgb(0.93, 0.57, 0.13)).
latex_colour('Ceil', "#92A1CF", ceil, rgb(0.57, 0.63, 0.81)).
latex_colour('Celadon', "#ACE1AF", celadon, rgb(0.67, 0.88, 0.69)).
latex_colour('Celestial blue', "#4997D0", celestialblue, rgb(0.29, 0.59, 0.82)).
latex_colour('Cerise', "#DE3163", cerise, rgb(0.87, 0.19, 0.39)).
latex_colour('Cerise pink', "#EC3B83", cerisepink, rgb(0.93, 0.23, 0.51)).
latex_colour('Cerulean', "#007BA7", cerulean, rgb(0.0, 0.48, 0.65)).
latex_colour('Cerulean blue', "#2A52BE", ceruleanblue, rgb(0.16, 0.32, 0.75)).
latex_colour('Chamoisee', "#A0785A", chamoisee, rgb(0.63, 0.47, 0.35)).
latex_colour('Champagne', "#F7E7CE", champagne, rgb(0.97, 0.91, 0.81)).
latex_colour('Charcoal', "#36454F", charcoal, rgb(0.21, 0.27, 0.31)).
latex_colour('Chartreuse (traditional)', "#DFFF00", 'chartreuse(traditional)', rgb(0.87, 1.0, 0.0)).
latex_colour('Chartreuse (web)', "#7FFF00", 'chartreuse(web)', rgb(0.5, 1.0, 0.0)).
latex_colour('Cherry blossom pink', "#FFB7C5", cherryblossompink, rgb(1.0, 0.72, 0.77)).
latex_colour('Chestnut', "#CD5C5C", chestnut, rgb(0.8, 0.36, 0.36)).
latex_colour('Chocolate (traditional)', "#7B3F00", 'chocolate(traditional)', rgb(0.48, 0.25, 0.0)).
latex_colour('Chocolate (web)', "#D2691E", 'chocolate(web)', rgb(0.82, 0.41, 0.12)).
latex_colour('Chrome yellow', "#FFA700", chromeyellow, rgb(1.0, 0.65, 0.0)).
latex_colour('Cinereous', "#98817B", cinereous, rgb(0.6, 0.51, 0.48)).
latex_colour('Cinnabar', "#E34234", cinnabar, rgb(0.89, 0.26, 0.2)).
latex_colour('Cinnamon', "#D2691E", cinnamon, rgb(0.82, 0.41, 0.12)).
latex_colour('Citrine', "#E4D00A", citrine, rgb(0.89, 0.82, 0.04)).
latex_colour('Classic rose', "#FBCCE7", classicrose, rgb(0.98, 0.8, 0.91)).
latex_colour('Cobalt', "#0047AB", cobalt, rgb(0.0, 0.28, 0.67)).
latex_colour('Cocoa brown', "#D2691E", cocoabrown, rgb(0.82, 0.41, 0.12)).
latex_colour('Columbia blue', "#9BDDFF", columbiablue, rgb(0.61, 0.87, 1.0)).
latex_colour('Cool black', "#002E63", coolblack, rgb(0.0, 0.18, 0.39)).
latex_colour('Cool grey', "#8C92AC", coolgrey, rgb(0.55, 0.57, 0.67)).
latex_colour('Copper', "#B87333", copper, rgb(0.72, 0.45, 0.2)).
latex_colour('Copper rose', "#996666", copperrose, rgb(0.6, 0.4, 0.4)).
latex_colour('Coquelicot', "#FF3800", coquelicot, rgb(1.0, 0.22, 0.0)).
latex_colour('Coral', "#FF7F50", coral, rgb(1.0, 0.5, 0.31)).
latex_colour('Coral pink', "#F88379", coralpink, rgb(0.97, 0.51, 0.47)).
latex_colour('Coral red', "#FF4040", coralred, rgb(1.0, 0.25, 0.25)).
latex_colour('Cordovan', "#893F45", cordovan, rgb(0.54, 0.25, 0.27)).
latex_colour('Corn', "#FBEC5D", corn, rgb(0.98, 0.93, 0.36)).
latex_colour('Cornell Red', "#B31B1B", cornellred, rgb(0.7, 0.11, 0.11)).
latex_colour('Cornflower blue', "#6495ED", cornflowerblue, rgb(0.39, 0.58, 0.93)).
latex_colour('Cornsilk', "#FFF8DC", cornsilk, rgb(1.0, 0.97, 0.86)).
latex_colour('Cosmic latte', "#FFF8E7", cosmiclatte, rgb(1.0, 0.97, 0.91)).
latex_colour('Cotton candy', "#FFBCD9", cottoncandy, rgb(1.0, 0.74, 0.85)).
latex_colour('Cream', "#FFFDD0", cream, rgb(1.0, 0.99, 0.82)).
latex_colour('Crimson', "#DC143C", crimson, rgb(0.86, 0.08, 0.24)).
latex_colour('Crimson glory', "#BE0032", crimsonglory, rgb(0.75, 0.0, 0.2)).
latex_colour('Cyan', "#00FFFF", cyan, rgb(0.0, 1.0, 1.0)).
latex_colour('Cyan (process)', "#00B7EB", 'cyan(process)', rgb(0.0, 0.72, 0.92)).
latex_colour('Daffodil', "#FFFF31", daffodil, rgb(1.0, 1.0, 0.19)).
latex_colour('Dandelion', "#F0E130", dandelion, rgb(0.94, 0.88, 0.19)).
latex_colour('Dark blue', "#00008B", darkblue, rgb(0.0, 0.0, 0.55)).
latex_colour('Dark brown', "#654321", darkbrown, rgb(0.4, 0.26, 0.13)).
latex_colour('Dark byzantium', "#5D3954", darkbyzantium, rgb(0.36, 0.22, 0.33)).
latex_colour('Dark candy apple red', "#A40000", darkcandyapplered, rgb(0.64, 0.0, 0.0)).
latex_colour('Dark cerulean', "#08457E", darkcerulean, rgb(0.03, 0.27, 0.49)).
latex_colour('Dark champagne', "#C2B280", darkchampagne, rgb(0.76, 0.7, 0.5)).
latex_colour('Dark chestnut', "#986960", darkchestnut, rgb(0.6, 0.41, 0.38)).
latex_colour('Dark coral', "#CD5B45", darkcoral, rgb(0.8, 0.36, 0.27)).
latex_colour('Dark cyan', "#008B8B", darkcyan, rgb(0.0, 0.55, 0.55)).
latex_colour('Dark electric blue', "#536878", darkelectricblue, rgb(0.33, 0.41, 0.47)).
latex_colour('Dark goldenrod', "#B8860B", darkgoldenrod, rgb(0.72, 0.53, 0.04)).
latex_colour('Dark gray', "#A9A9A9", darkgray, rgb(0.66, 0.66, 0.66)).
latex_colour('Dark green', "#013220", darkgreen, rgb(0.0, 0.2, 0.13)).
latex_colour('Dark jungle green', "#1A2421", darkjunglegreen, rgb(0.1, 0.14, 0.13)).
latex_colour('Dark khaki', "#BDB76B", darkkhaki, rgb(0.74, 0.72, 0.42)).
latex_colour('Dark lava', "#483C32", darklava, rgb(0.28, 0.24, 0.2)).
latex_colour('Dark lavender', "#734F96", darklavender, rgb(0.45, 0.31, 0.59)).
latex_colour('Dark magenta', "#8B008B", darkmagenta, rgb(0.55, 0.0, 0.55)).
latex_colour('Dark midnight blue', "#003366", darkmidnightblue, rgb(0.0, 0.2, 0.4)).
latex_colour('Dark olive green', "#556B2F", darkolivegreen, rgb(0.33, 0.42, 0.18)).
latex_colour('Dark orange', "#FF8C00", darkorange, rgb(1.0, 0.55, 0.0)).
latex_colour('Dark orchid', "#9932CC", darkorchid, rgb(0.6, 0.2, 0.8)).
latex_colour('Dark pastel blue', "#779ECB", darkpastelblue, rgb(0.47, 0.62, 0.8)).
latex_colour('Dark pastel green', "#03C03C", darkpastelgreen, rgb(0.01, 0.75, 0.24)).
latex_colour('Dark pastel purple', "#966FD6", darkpastelpurple, rgb(0.59, 0.44, 0.84)).
latex_colour('Dark pastel red', "#C23B22", darkpastelred, rgb(0.76, 0.23, 0.13)).
latex_colour('Dark pink', "#E75480", darkpink, rgb(0.91, 0.33, 0.5)).
latex_colour('Dark powder blue', "#003399", darkpowderblue, rgb(0.0, 0.2, 0.6)).
latex_colour('Dark raspberry', "#872657", darkraspberry, rgb(0.53, 0.15, 0.34)).
latex_colour('Dark red', "#8B0000", darkred, rgb(0.55, 0.0, 0.0)).
latex_colour('Dark salmon', "#E9967A", darksalmon, rgb(0.91, 0.59, 0.48)).
latex_colour('Dark scarlet', "#560319", darkscarlet, rgb(0.34, 0.01, 0.1)).
latex_colour('Dark sea green', "#8FBC8F", darkseagreen, rgb(0.56, 0.74, 0.56)).
latex_colour('Dark sienna', "#3C1414", darksienna, rgb(0.24, 0.08, 0.08)).
latex_colour('Dark slate blue', "#483D8B", darkslateblue, rgb(0.28, 0.24, 0.55)).
latex_colour('Dark slate gray', "#2F4F4F", darkslategray, rgb(0.18, 0.31, 0.31)).
latex_colour('Dark spring green', "#177245", darkspringgreen, rgb(0.09, 0.45, 0.27)).
latex_colour('Dark tan', "#918151", darktan, rgb(0.57, 0.51, 0.32)).
latex_colour('Dark tangerine', "#FFA812", darktangerine, rgb(1.0, 0.66, 0.07)).
latex_colour('Dark taupe', "#483C32", darktaupe, rgb(0.28, 0.24, 0.2)).
latex_colour('Dark terra cotta', "#CC4E5C", darkterracotta, rgb(0.8, 0.31, 0.36)).
latex_colour('Dark turquoise', "#00CED1", darkturquoise, rgb(0.0, 0.81, 0.82)).
latex_colour('Dark violet', "#9400D3", darkviolet, rgb(0.58, 0.0, 0.83)).
latex_colour('Dartmouth green', "#00693E", dartmouthgreen, rgb(0.05, 0.5, 0.06)).
latex_colour('Davy\\\'s grey', "#555555", 'davy\\\'sgrey', rgb(0.33, 0.33, 0.33)).
latex_colour('Debian red', "#D70A53", debianred, rgb(0.84, 0.04, 0.33)).
latex_colour('Deep carmine', "#A9203E", deepcarmine, rgb(0.66, 0.13, 0.24)).
latex_colour('Deep carmine pink', "#EF3038", deepcarminepink, rgb(0.94, 0.19, 0.22)).
latex_colour('Deep carrot orange', "#E9692C", deepcarrotorange, rgb(0.91, 0.41, 0.17)).
latex_colour('Deep cerise', "#DA3287", deepcerise, rgb(0.85, 0.2, 0.53)).
latex_colour('Deep champagne', "#FAD6A5", deepchampagne, rgb(0.98, 0.84, 0.65)).
latex_colour('Deep chestnut', "#B94E48", deepchestnut, rgb(0.73, 0.31, 0.28)).
latex_colour('Deep fuchsia', "#C154C1", deepfuchsia, rgb(0.76, 0.33, 0.76)).
latex_colour('Deep jungle green', "#004B49", deepjunglegreen, rgb(0.0, 0.29, 0.29)).
latex_colour('Deep lilac', "#9955BB", deeplilac, rgb(0.6, 0.33, 0.73)).
latex_colour('Deep magenta', "#CC00CC", deepmagenta, rgb(0.8, 0.0, 0.8)).
latex_colour('Deep peach', "#FFCBA4", deeppeach, rgb(1.0, 0.8, 0.64)).
latex_colour('Deep pink', "#FF1493", deeppink, rgb(1.0, 0.08, 0.58)).
latex_colour('Deep saffron', "#FF9933", deepsaffron, rgb(1.0, 0.6, 0.2)).
latex_colour('Deep sky blue', "#00BFFF", deepskyblue, rgb(0.0, 0.75, 1.0)).
latex_colour('Denim', "#1560BD", denim, rgb(0.08, 0.38, 0.74)).
latex_colour('Desert', "#C19A6B", desert, rgb(0.76, 0.6, 0.42)).
latex_colour('Desert sand', "#EDC9AF", desertsand, rgb(0.93, 0.79, 0.69)).
latex_colour('Dim gray', "#696969", dimgray, rgb(0.41, 0.41, 0.41)).
latex_colour('Dodger blue', "#1E90FF", dodgerblue, rgb(0.12, 0.56, 1.0)).
latex_colour('Dogwood rose', "#D71868", dogwoodrose, rgb(0.84, 0.09, 0.41)).
latex_colour('Dollar bill', "#85BB65", dollarbill, rgb(0.52, 0.73, 0.4)).
latex_colour('Drab', "#967117", drab, rgb(0.59, 0.44, 0.09)).
latex_colour('Duke blue', "#00009C", dukeblue, rgb(0.0, 0.0, 0.61)).
latex_colour('Earth yellow', "#E1A95F", earthyellow, rgb(0.88, 0.66, 0.37)).
latex_colour('Ecru', "#C2B280", ecru, rgb(0.76, 0.7, 0.5)).
latex_colour('Eggplant', "#614051", eggplant, rgb(0.38, 0.25, 0.32)).
latex_colour('Eggshell', "#F0EAD6", eggshell, rgb(0.94, 0.92, 0.84)).
latex_colour('Egyptian blue', "#1034A6", egyptianblue, rgb(0.06, 0.2, 0.65)).
latex_colour('Electric blue', "#7DF9FF", electricblue, rgb(0.49, 0.98, 1.0)).
latex_colour('Electric crimson', "#FF003F", electriccrimson, rgb(1.0, 0.0, 0.25)).
latex_colour('Electric cyan', "#00FFFF", electriccyan, rgb(0.0, 1.0, 1.0)).
latex_colour('Electric green', "#00FF00", electricgreen, rgb(0.0, 1.0, 0.0)).
latex_colour('Electric indigo', "#6F00FF", electricindigo, rgb(0.44, 0.0, 1.0)).
latex_colour('Electric lavender', "#F4BBFF", electriclavender, rgb(0.96, 0.73, 1.0)).
latex_colour('Electric lime', "#CCFF00", electriclime, rgb(0.8, 1.0, 0.0)).
latex_colour('Electric purple', "#BF00FF", electricpurple, rgb(0.75, 0.0, 1.0)).
latex_colour('Electric ultramarine', "#3F00FF", electricultramarine, rgb(0.25, 0.0, 1.0)).
latex_colour('Electric violet', "#8F00FF", electricviolet, rgb(0.56, 0.0, 1.0)).
latex_colour('Electric Yellow', "#FFFF00", electricyellow, rgb(1.0, 1.0, 0.0)).
latex_colour('Emerald', "#50C878", emerald, rgb(0.31, 0.78, 0.47)).
latex_colour('Eton blue', "#96C8A2", etonblue, rgb(0.59, 0.78, 0.64)).
latex_colour('Fallow', "#C19A6B", fallow, rgb(0.76, 0.6, 0.42)).
latex_colour('Falu red', "#801818", falured, rgb(0.5, 0.09, 0.09)).
latex_colour('Fandango', "#B53389", fandango, rgb(0.71, 0.2, 0.54)).
latex_colour('Fashion fuchsia', "#F400A1", fashionfuchsia, rgb(0.96, 0.0, 0.63)).
latex_colour('Fawn', "#E5AA70", fawn, rgb(0.9, 0.67, 0.44)).
latex_colour('Feldgrau', "#4D5D53", feldgrau, rgb(0.3, 0.36, 0.33)).
latex_colour('Fern green', "#4F7942", ferngreen, rgb(0.31, 0.47, 0.26)).
latex_colour('Ferrari Red', "#FF2800", ferrarired, rgb(1.0, 0.11, 0.0)).
latex_colour('Field drab', "#6C541E", fielddrab, rgb(0.42, 0.33, 0.12)).
latex_colour('Firebrick', "#B22222", firebrick, rgb(0.7, 0.13, 0.13)).
latex_colour('Fire engine red', "#CE2029", fireenginered, rgb(0.81, 0.09, 0.13)).
latex_colour('Flame', "#E25822", flame, rgb(0.89, 0.35, 0.13)).
latex_colour('Flamingo pink', "#FC8EAC", flamingopink, rgb(0.99, 0.56, 0.67)).
latex_colour('Flavescent', "#F7E98E", flavescent, rgb(0.97, 0.91, 0.56)).
latex_colour('Flax', "#EEDC82", flax, rgb(0.93, 0.86, 0.51)).
latex_colour('Floral white', "#FFFAF0", floralwhite, rgb(1.0, 0.98, 0.94)).
latex_colour('Fluorescent orange', "#FFBF00", fluorescentorange, rgb(1.0, 0.75, 0.0)).
latex_colour('Fluorescent pink', "#FF1493", fluorescentpink, rgb(1.0, 0.08, 0.58)).
latex_colour('Fluorescent yellow', "#CCFF00", fluorescentyellow, rgb(0.8, 1.0, 0.0)).
latex_colour('Folly', "#FF004F", folly, rgb(1.0, 0.0, 0.31)).
latex_colour('Forest green (traditional)', "#014421", 'forestgreen(traditional)', rgb(0.0, 0.27, 0.13)).
latex_colour('Forest green (web)', "#228B22", 'forestgreen(web)', rgb(0.13, 0.55, 0.13)).
latex_colour('French beige', "#A67B5B", frenchbeige, rgb(0.65, 0.48, 0.36)).
latex_colour('French blue', "#0072BB", frenchblue, rgb(0.0, 0.45, 0.73)).
latex_colour('French lilac', "#86608E", frenchlilac, rgb(0.53, 0.38, 0.56)).
latex_colour('French rose', "#F64A8A", frenchrose, rgb(0.96, 0.29, 0.54)).
latex_colour('Fuchsia', "#FF00FF", fuchsia, rgb(1.0, 0.0, 1.0)).
latex_colour('Fuchsia pink', "#FF77FF", fuchsiapink, rgb(1.0, 0.47, 1.0)).
latex_colour('Fulvous', "#E48400", fulvous, rgb(0.86, 0.52, 0.0)).
latex_colour('Fuzzy Wuzzy', "#CC6666", fuzzywuzzy, rgb(0.8, 0.4, 0.4)).
latex_colour('Gainsboro', "#DCDCDC", gainsboro, rgb(0.86, 0.86, 0.86)).
latex_colour('Gamboge', "#E49B0F", gamboge, rgb(0.89, 0.61, 0.06)).
latex_colour('Ghost white', "#F8F8FF", ghostwhite, rgb(0.97, 0.97, 1.0)).
latex_colour('Ginger', "#B06500", ginger, rgb(0.69, 0.4, 0.0)).
latex_colour('Glaucous', "#6082B6", glaucous, rgb(0.38, 0.51, 0.71)).
latex_colour('Gold (metallic)', "#D4AF37", 'gold(metallic)', rgb(0.83, 0.69, 0.22)).
latex_colour('Gold (web) (Golden)', "#FFD700", 'gold(web)(golden)', rgb(1.0, 0.84, 0.0)).
latex_colour('Golden brown', "#996515", goldenbrown, rgb(0.6, 0.4, 0.08)).
latex_colour('Golden poppy', "#FCC200", goldenpoppy, rgb(0.99, 0.76, 0.0)).
latex_colour('Golden yellow', "#FFDF00", goldenyellow, rgb(1.0, 0.87, 0.0)).
latex_colour('Goldenrod', "#DAA520", goldenrod, rgb(0.85, 0.65, 0.13)).
latex_colour('Granny Smith Apple', "#A8E4A0", grannysmithapple, rgb(0.66, 0.89, 0.63)).
latex_colour('Gray', "#808080", gray, rgb(0.5, 0.5, 0.5)).
latex_colour('Gray (HTML/CSS gray)', "#7F7F7F", 'gray(html/cssgray)', rgb(0.5, 0.5, 0.5)).
latex_colour('Gray (X11 gray)', "#BEBEBE", 'gray(x11gray)', rgb(0.75, 0.75, 0.75)).
latex_colour('Gray-asparagus', "#465945", 'gray-asparagus', rgb(0.27, 0.35, 0.27)).
latex_colour('Green (color wheel) (X11 green)', "#00FF00", 'green(colorwheel)(x11green)', rgb(0.0, 1.0, 0.0)).
latex_colour('Green (HTML/CSS green)', "#008000", 'green(html/cssgreen)', rgb(0.0, 0.5, 0.0)).
latex_colour('Green (Munsell)', "#00A877", 'green(munsell)', rgb(0.0, 0.66, 0.47)).
latex_colour('Green (NCS)', "#009F6B", 'green(ncs)', rgb(0.0, 0.62, 0.42)).
latex_colour('Green (pigment)', "#00A550", 'green(pigment)', rgb(0.0, 0.65, 0.31)).
latex_colour('Green (RYB)', "#66B032", 'green(ryb)', rgb(0.4, 0.69, 0.2)).
latex_colour('Green-yellow', "#ADFF2F", 'green-yellow', rgb(0.68, 1.0, 0.18)).
latex_colour('Grullo', "#A99A86", grullo, rgb(0.66, 0.6, 0.53)).
latex_colour('Guppie green', "#00FF7F", guppiegreen, rgb(0.0, 1.0, 0.5)).
latex_colour('Halaya ube', "#663854", halayaube, rgb(0.4, 0.22, 0.33)).
latex_colour('Han blue', "#446CCF", hanblue, rgb(0.27, 0.42, 0.81)).
latex_colour('Han purple', "#5218FA", hanpurple, rgb(0.32, 0.09, 0.98)).
latex_colour('Hansa yellow', "#E9D66B", hansayellow, rgb(0.91, 0.84, 0.42)).
latex_colour('Harlequin', "#3FFF00", harlequin, rgb(0.25, 1.0, 0.0)).
latex_colour('Harvard crimson', "#C90016", harvardcrimson, rgb(0.79, 0.0, 0.09)).
latex_colour('Harvest Gold', "#DA9100", harvestgold, rgb(0.85, 0.57, 0.0)).
latex_colour('Heart Gold', "#808000", heartgold, rgb(0.5, 0.5, 0.0)).
latex_colour('Heliotrope', "#DF73FF", heliotrope, rgb(0.87, 0.45, 1.0)).
latex_colour('Hollywood cerise', "#F400A1", hollywoodcerise, rgb(0.96, 0.0, 0.63)).
latex_colour('Honeydew', "#F0FFF0", honeydew, rgb(0.94, 1.0, 0.94)).
latex_colour('Hooker\\\'s green', "#007000", 'hooker\\\'sgreen', rgb(0.0, 0.44, 0.0)).
latex_colour('Hot magenta', "#FF1DCE", hotmagenta, rgb(1.0, 0.11, 0.81)).
latex_colour('Hot pink', "#FF69B4", hotpink, rgb(1.0, 0.41, 0.71)).
latex_colour('Hunter green', "#355E3B", huntergreen, rgb(0.21, 0.37, 0.23)).
latex_colour('Iceberg', "#71A6D2", iceberg, rgb(0.44, 0.65, 0.82)).
latex_colour('Icterine', "#FCF75E", icterine, rgb(0.99, 0.97, 0.37)).
latex_colour('Inchworm', "#B2EC5D", inchworm, rgb(0.7, 0.93, 0.36)).
latex_colour('India green', "#138808", indiagreen, rgb(0.07, 0.53, 0.03)).
latex_colour('Indian red', "#CD5C5C", indianred, rgb(0.8, 0.36, 0.36)).
latex_colour('Indian yellow', "#E3A857", indianyellow, rgb(0.89, 0.66, 0.34)).
latex_colour('Indigo (dye)', "#00416A", 'indigo(dye)', rgb(0.0, 0.25, 0.42)).
latex_colour('Indigo (web)', "#4B0082", 'indigo(web)', rgb(0.29, 0.0, 0.51)).
latex_colour('International Klein Blue', "#002FA7", internationalkleinblue, rgb(0.0, 0.18, 0.65)).
latex_colour('International orange', "#FF4F00", internationalorange, rgb(1.0, 0.31, 0.0)).
latex_colour('Iris', "#5A4FCF", iris, rgb(0.35, 0.31, 0.81)).
latex_colour('Isabelline', "#F4F0EC", isabelline, rgb(0.96, 0.94, 0.93)).
latex_colour('Islamic green', "#009000", islamicgreen, rgb(0.0, 0.56, 0.0)).
latex_colour('Ivory', "#FFFFF0", ivory, rgb(1.0, 1.0, 0.94)).
latex_colour('Jade', "#00A86B", jade, rgb(0.0, 0.66, 0.42)).
latex_colour('Jasper', "#D73B3E", jasper, rgb(0.84, 0.23, 0.24)).
latex_colour('Jazzberry jam', "#A50B5E", jazzberryjam, rgb(0.65, 0.04, 0.37)).
latex_colour('Jonquil', "#FADA5E", jonquil, rgb(0.98, 0.85, 0.37)).
latex_colour('June bud', "#BDDA57", junebud, rgb(0.74, 0.85, 0.34)).
latex_colour('Jungle green', "#29AB87", junglegreen, rgb(0.16, 0.67, 0.53)).
latex_colour('Kelly green', "#4CBB17", kellygreen, rgb(0.3, 0.73, 0.09)).
latex_colour('Khaki (HTML/CSS) (Khaki)', "#C3B091", 'khaki(html/css)(khaki)', rgb(0.76, 0.69, 0.57)).
latex_colour('Khaki (X11) (Light khaki)', "#F0E68C", 'khaki(x11)(lightkhaki)', rgb(0.94, 0.9, 0.55)).
latex_colour('La Salle Green', "#087830", lasallegreen, rgb(0.03, 0.47, 0.19)).
latex_colour('Languid lavender', "#D6CADD", languidlavender, rgb(0.84, 0.79, 0.87)).
latex_colour('Lapis lazuli', "#26619C", lapislazuli, rgb(0.15, 0.38, 0.61)).
latex_colour('Laser Lemon', "#FEFE22", laserlemon, rgb(1.0, 1.0, 0.13)).
latex_colour('Lava', "#CF1020", lava, rgb(0.81, 0.06, 0.13)).
latex_colour('Lavender (floral)', "#B57EDC", 'lavender(floral)', rgb(0.71, 0.49, 0.86)).
latex_colour('Lavender (web)', "#E6E6FA", 'lavender(web)', rgb(0.9, 0.9, 0.98)).
latex_colour('Lavender blue', "#CCCCFF", lavenderblue, rgb(0.8, 0.8, 1.0)).
latex_colour('Lavender blush', "#FFF0F5", lavenderblush, rgb(1.0, 0.94, 0.96)).
latex_colour('Lavender gray', "#C4C3D0", lavendergray, rgb(0.77, 0.76, 0.82)).
latex_colour('Lavender indigo', "#9457EB", lavenderindigo, rgb(0.58, 0.34, 0.92)).
latex_colour('Lavender magenta', "#EE82EE", lavendermagenta, rgb(0.93, 0.51, 0.93)).
latex_colour('Lavender mist', "#E6E6FA", lavendermist, rgb(0.9, 0.9, 0.98)).
latex_colour('Lavender pink', "#FBAED2", lavenderpink, rgb(0.98, 0.68, 0.82)).
latex_colour('Lavender purple', "#967BB6", lavenderpurple, rgb(0.59, 0.48, 0.71)).
latex_colour('Lavender rose', "#FBA0E3", lavenderrose, rgb(0.98, 0.63, 0.89)).
latex_colour('Lawn green', "#7CFC00", lawngreen, rgb(0.49, 0.99, 0.0)).
latex_colour('Lemon', "#FFF700", lemon, rgb(1.0, 0.97, 0.0)).
latex_colour('Lemon chiffon', "#FFFACD", lemonchiffon, rgb(1.0, 0.98, 0.8)).
latex_colour('Light apricot', "#FDD5B1", lightapricot, rgb(0.99, 0.84, 0.69)).
latex_colour('Light blue', "#ADD8E6", lightblue, rgb(0.68, 0.85, 0.9)).
latex_colour('Light brown', "#B5651D", lightbrown, rgb(0.71, 0.4, 0.11)).
latex_colour('Light carmine pink', "#E66771", lightcarminepink, rgb(0.9, 0.4, 0.38)).
latex_colour('Light coral', "#F08080", lightcoral, rgb(0.94, 0.5, 0.5)).
latex_colour('Light cornflower blue', "#93CCEA", lightcornflowerblue, rgb(0.6, 0.81, 0.93)).
latex_colour('Light cyan', "#E0FFFF", lightcyan, rgb(0.88, 1.0, 1.0)).
latex_colour('Light fuchsia pink', "#F984EF", lightfuchsiapink, rgb(0.98, 0.52, 0.9)).
latex_colour('Light goldenrod yellow', "#FAFAD2", lightgoldenrodyellow, rgb(0.98, 0.98, 0.82)).
latex_colour('Light gray', "#D3D3D3", lightgray, rgb(0.83, 0.83, 0.83)).
latex_colour('Light green', "#90EE90", lightgreen, rgb(0.56, 0.93, 0.56)).
latex_colour('Light khaki', "#F0E68C", lightkhaki, rgb(0.94, 0.9, 0.55)).
latex_colour('Light mauve', "#DCD0FF", lightmauve, rgb(0.86, 0.82, 1.0)).
latex_colour('Light pastel purple', "#B19CD9", lightpastelpurple, rgb(0.69, 0.61, 0.85)).
latex_colour('Light pink', "#FFB6C1", lightpink, rgb(1.0, 0.71, 0.76)).
latex_colour('Light salmon', "#FFA07A", lightsalmon, rgb(1.0, 0.63, 0.48)).
latex_colour('Light salmon pink', "#FF9999", lightsalmonpink, rgb(1.0, 0.6, 0.6)).
latex_colour('Light sea green', "#20B2AA", lightseagreen, rgb(0.13, 0.7, 0.67)).
latex_colour('Light sky blue', "#87CEEB", lightskyblue, rgb(0.53, 0.81, 0.98)).
latex_colour('Light slate gray', "#778899", lightslategray, rgb(0.47, 0.53, 0.6)).
latex_colour('Light taupe', "#B38B6D", lighttaupe, rgb(0.7, 0.55, 0.43)).
latex_colour('Light Thulian pink', "#E68FAC", lightthulianpink, rgb(0.9, 0.56, 0.67)).
latex_colour('Light yellow', "#FFFFED", lightyellow, rgb(1.0, 1.0, 0.88)).
latex_colour('Lilac', "#C8A2C8", lilac, rgb(0.78, 0.64, 0.78)).
latex_colour('Lime (color wheel)', "#BFFF00", 'lime(colorwheel)', rgb(0.75, 1.0, 0.0)).
latex_colour('Lime (web) (X11 green)', "#00FF00", 'lime(web)(x11green)', rgb(0.0, 1.0, 0.0)).
latex_colour('Lime green', "#32CD32", limegreen, rgb(0.2, 0.8, 0.2)).
latex_colour('Lincoln green', "#195905", lincolngreen, rgb(0.11, 0.35, 0.02)).
latex_colour('Linen', "#FAF0E6", linen, rgb(0.98, 0.94, 0.9)).
latex_colour('Liver', "#534B4F", liver, rgb(0.33, 0.29, 0.31)).
latex_colour('Lust', "#E62020", lust, rgb(0.9, 0.13, 0.13)).
latex_colour('Macaroni and Cheese', "#FFBD88", macaroniandcheese, rgb(1.0, 0.74, 0.53)).
latex_colour('Magenta', "#FF00FF", magenta, rgb(1.0, 0.0, 1.0)).
latex_colour('Magenta (dye)', "#CA1F7B", 'magenta(dye)', rgb(0.79, 0.08, 0.48)).
latex_colour('Magenta (process)', "#FF0090", 'magenta(process)', rgb(1.0, 0.0, 0.56)).
latex_colour('Magic mint', "#AAF0D1", magicmint, rgb(0.67, 0.94, 0.82)).
latex_colour('Magnolia', "#F8F4FF", magnolia, rgb(0.97, 0.96, 1.0)).
latex_colour('Mahogany', "#C04000", mahogany, rgb(0.75, 0.25, 0.0)).
latex_colour('Maize', "#FBEC5D", maize, rgb(0.98, 0.93, 0.37)).
latex_colour('Majorelle Blue', "#6050DC", majorelleblue, rgb(0.38, 0.31, 0.86)).
latex_colour('Malachite', "#0BDA51", malachite, rgb(0.04, 0.85, 0.32)).
latex_colour('Manatee', "#979AAA", manatee, rgb(0.59, 0.6, 0.67)).
latex_colour('Mango Tango', "#FF8243", mangotango, rgb(1.0, 0.51, 0.26)).
latex_colour('Maroon (HTML/CSS)', "#800000", 'maroon(html/css)', rgb(0.5, 0.0, 0.0)).
latex_colour('Maroon (X11)', "#B03060", 'maroon(x11)', rgb(0.69, 0.19, 0.38)).
latex_colour('Mauve', "#E0B0FF", mauve, rgb(0.88, 0.69, 1.0)).
latex_colour('Mauve taupe', "#915F6D", mauvetaupe, rgb(0.57, 0.37, 0.43)).
latex_colour('Mauvelous', "#EF98AA", mauvelous, rgb(0.94, 0.6, 0.67)).
latex_colour('Maya blue', "#73C2FB", mayablue, rgb(0.45, 0.76, 0.98)).
latex_colour('Meat brown', "#E5B73B", meatbrown, rgb(0.9, 0.72, 0.23)).
latex_colour('Medium aquamarine', "#66DDAA", mediumaquamarine, rgb(0.4, 0.8, 0.67)).
latex_colour('Medium blue', "#0000CD", mediumblue, rgb(0.0, 0.0, 0.8)).
latex_colour('Medium candy apple red', "#E2062C", mediumcandyapplered, rgb(0.89, 0.02, 0.17)).
latex_colour('Medium carmine', "#AF4035", mediumcarmine, rgb(0.69, 0.25, 0.21)).
latex_colour('Medium champagne', "#F3E5AB", mediumchampagne, rgb(0.95, 0.9, 0.67)).
latex_colour('Medium electric blue', "#035096", mediumelectricblue, rgb(0.01, 0.31, 0.59)).
latex_colour('Medium jungle green', "#1C352D", mediumjunglegreen, rgb(0.11, 0.21, 0.18)).
latex_colour('Medium lavender magenta', "#DDA0DD", mediumlavendermagenta, rgb(0.8, 0.6, 0.8)).
latex_colour('Medium orchid', "#BA55D3", mediumorchid, rgb(0.73, 0.33, 0.83)).
latex_colour('Medium Persian blue', "#0067A5", mediumpersianblue, rgb(0.0, 0.4, 0.65)).
latex_colour('Medium purple', "#9370DB", mediumpurple, rgb(0.58, 0.44, 0.86)).
latex_colour('Medium red-violet', "#BB3385", 'mediumred-violet', rgb(0.73, 0.2, 0.52)).
latex_colour('Medium sea green', "#3CB371", mediumseagreen, rgb(0.24, 0.7, 0.44)).
latex_colour('Medium slate blue', "#7B68EE", mediumslateblue, rgb(0.48, 0.41, 0.93)).
latex_colour('Medium spring bud', "#C9DC87", mediumspringbud, rgb(0.79, 0.86, 0.54)).
latex_colour('Medium spring green', "#00FA9A", mediumspringgreen, rgb(0.0, 0.98, 0.6)).
latex_colour('Medium taupe', "#674C47", mediumtaupe, rgb(0.4, 0.3, 0.28)).
latex_colour('Medium teal blue', "#0054B4", mediumtealblue, rgb(0.0, 0.33, 0.71)).
latex_colour('Medium turquoise', "#48D1CC", mediumturquoise, rgb(0.28, 0.82, 0.8)).
latex_colour('Medium violet-red', "#C71585", 'mediumviolet-red', rgb(0.78, 0.08, 0.52)).
latex_colour('Melon', "#FDBCB4", melon, rgb(0.99, 0.74, 0.71)).
latex_colour('Midnight blue', "#191970", midnightblue, rgb(0.1, 0.1, 0.44)).
latex_colour('Midnight green (eagle green)', "#004953", 'midnightgreen(eaglegreen)', rgb(0.0, 0.29, 0.33)).
latex_colour('Mikado yellow', "#FFC40C", mikadoyellow, rgb(1.0, 0.77, 0.05)).
latex_colour('Mint', "#3EB489", mint, rgb(0.24, 0.71, 0.54)).
latex_colour('Mint cream', "#F5FFFA", mintcream, rgb(0.96, 1.0, 0.98)).
latex_colour('Mint green', "#98FF98", mintgreen, rgb(0.6, 1.0, 0.6)).
latex_colour('Misty rose', "#FFE4E1", mistyrose, rgb(1.0, 0.89, 0.88)).
latex_colour('Moccasin', "#FAEBD7", moccasin, rgb(0.98, 0.92, 0.84)).
latex_colour('Mode beige', "#967117", modebeige, rgb(0.59, 0.44, 0.09)).
latex_colour('Moonstone blue', "#73A9C2", moonstoneblue, rgb(0.45, 0.66, 0.76)).
latex_colour('Mordant red 19', "#AE0C00", mordantred19, rgb(0.68, 0.05, 0.0)).
latex_colour('Moss green', "#ADDFAD", mossgreen, rgb(0.68, 0.87, 0.68)).
latex_colour('Mountain Meadow', "#30BA8F", mountainmeadow, rgb(0.19, 0.73, 0.56)).
latex_colour('Mountbatten pink', "#997A8D", mountbattenpink, rgb(0.6, 0.48, 0.55)).
latex_colour('Mulberry', "#C54B8C", mulberry, rgb(0.77, 0.29, 0.55)).
latex_colour('Mustard', "#FFDB58", mustard, rgb(1.0, 0.86, 0.35)).
latex_colour('Myrtle', "#21421E", myrtle, rgb(0.13, 0.26, 0.12)).
latex_colour('MSU Green', "#18453B", msugreen, rgb(0.09, 0.27, 0.23)).
latex_colour('Nadeshiko pink', "#F6ADC6", nadeshikopink, rgb(0.96, 0.68, 0.78)).
latex_colour('Napier green', "#2A8000", napiergreen, rgb(0.16, 0.5, 0.0)).
latex_colour('Naples yellow', "#FADA5E", naplesyellow, rgb(0.98, 0.85, 0.37)).
latex_colour('Navajo white', "#FFDEAD", navajowhite, rgb(1.0, 0.87, 0.68)).
latex_colour('Navy blue', "#000080", navyblue, rgb(0.0, 0.0, 0.5)).
latex_colour('Neon Carrot', "#FFA343", neoncarrot, rgb(1.0, 0.64, 0.26)).
latex_colour('Neon fuchsia', "#FE59C2", neonfuchsia, rgb(1.0, 0.25, 0.39)).
latex_colour('Neon green', "#39FF14", neongreen, rgb(0.22, 0.88, 0.08)).
latex_colour('Non-photo blue', "#A4DDED", 'non-photoblue', rgb(0.64, 0.87, 0.93)).
latex_colour('Ocean Boat Blue', "#0077BE", oceanboatblue, rgb(0.0, 0.47, 0.75)).
latex_colour('Ochre', "#CC7722", ochre, rgb(0.8, 0.47, 0.13)).
latex_colour('Office green', "#008000", officegreen, rgb(0.0, 0.5, 0.0)).
latex_colour('Old gold', "#CFB53B", oldgold, rgb(0.81, 0.71, 0.23)).
latex_colour('Old lace', "#FDF5E6", oldlace, rgb(0.99, 0.96, 0.9)).
latex_colour('Old lavender', "#796878", oldlavender, rgb(0.47, 0.41, 0.47)).
latex_colour('Old mauve', "#673147", oldmauve, rgb(0.4, 0.19, 0.28)).
latex_colour('Old rose', "#C08081", oldrose, rgb(0.75, 0.5, 0.51)).
latex_colour('Olive', "#808000", olive, rgb(0.5, 0.5, 0.0)).
latex_colour('Olive Drab (web) (Olive Drab #3)', "#6B8E23", 'olivedrab(web)(olivedrab3)', rgb(0.42, 0.56, 0.14)).
latex_colour('Olive Drab #7', "#3C341F", olivedrab7, rgb(0.24, 0.2, 0.12)).
latex_colour('Olivine', "#9AB973", olivine, rgb(0.6, 0.73, 0.45)).
latex_colour('Onyx', "#0F0F0F", onyx, rgb(0.06, 0.06, 0.06)).
latex_colour('Opera mauve', "#B784A7", operamauve, rgb(0.72, 0.52, 0.65)).
latex_colour('Orange (color wheel)', "#FF7F00", 'orange(colorwheel)', rgb(1.0, 0.5, 0.0)).
latex_colour('Orange (RYB)', "#FB9902", 'orange(ryb)', rgb(0.98, 0.6, 0.01)).
latex_colour('Orange (web color)', "#FFA500", 'orange(webcolor)', rgb(1.0, 0.65, 0.0)).
latex_colour('Orange peel', "#FF9F00", orangepeel, rgb(1.0, 0.62, 0.0)).
latex_colour('Orange-red', "#FF4500", 'orange-red', rgb(1.0, 0.27, 0.0)).
latex_colour('Orchid', "#DA70D6", orchid, rgb(0.85, 0.44, 0.84)).
latex_colour('Otter brown', "#654321", otterbrown, rgb(0.4, 0.26, 0.13)).
latex_colour('Outer Space', "#414A4C", outerspace, rgb(0.25, 0.29, 0.3)).
latex_colour('Outrageous Orange', "#FF6E4A", outrageousorange, rgb(1.0, 0.43, 0.29)).
latex_colour('Oxford Blue', "#002147", oxfordblue, rgb(0.0, 0.13, 0.28)).
latex_colour('OU Crimson Red', "#990000", oucrimsonred, rgb(0.6, 0.0, 0.0)).
latex_colour('Pakistan green', "#006600", pakistangreen, rgb(0.0, 0.4, 0.0)).
latex_colour('Palatinate blue', "#273BE2", palatinateblue, rgb(0.15, 0.23, 0.89)).
latex_colour('Palatinate purple', "#682860", palatinatepurple, rgb(0.41, 0.16, 0.38)).
latex_colour('Pale aqua', "#BCD4E6", paleaqua, rgb(0.74, 0.83, 0.9)).
latex_colour('Pale blue', "#AFEEEE", paleblue, rgb(0.69, 0.93, 0.93)).
latex_colour('Pale brown', "#987654", palebrown, rgb(0.6, 0.46, 0.33)).
latex_colour('Pale carmine', "#AF4035", palecarmine, rgb(0.69, 0.25, 0.21)).
latex_colour('Pale cerulean', "#9BC4E2", palecerulean, rgb(0.61, 0.77, 0.89)).
latex_colour('Pale chestnut', "#DDADAF", palechestnut, rgb(0.87, 0.68, 0.69)).
latex_colour('Pale copper', "#DA8A67", palecopper, rgb(0.85, 0.54, 0.4)).
latex_colour('Pale cornflower blue', "#ABCDEF", palecornflowerblue, rgb(0.67, 0.8, 0.94)).
latex_colour('Pale gold', "#E6BE8A", palegold, rgb(0.9, 0.75, 0.54)).
latex_colour('Pale goldenrod', "#EEE8AA", palegoldenrod, rgb(0.93, 0.91, 0.67)).
latex_colour('Pale green', "#98FB98", palegreen, rgb(0.6, 0.98, 0.6)).
latex_colour('Pale magenta', "#F984E5", palemagenta, rgb(0.98, 0.52, 0.9)).
latex_colour('Pale pink', "#FADADD", palepink, rgb(0.98, 0.85, 0.87)).
latex_colour('Pale plum', "#DDA0DD", paleplum, rgb(0.8, 0.6, 0.8)).
latex_colour('Pale red-violet', "#DB7093", 'palered-violet', rgb(0.86, 0.44, 0.58)).
latex_colour('Pale robin egg blue', "#96DED1", palerobineggblue, rgb(0.59, 0.87, 0.82)).
latex_colour('Pale silver', "#C9C0BB", palesilver, rgb(0.79, 0.75, 0.73)).
latex_colour('Pale spring bud', "#ECEBBD", palespringbud, rgb(0.93, 0.92, 0.74)).
latex_colour('Pale taupe', "#BC987E", paletaupe, rgb(0.74, 0.6, 0.49)).
latex_colour('Pale violet-red', "#DB7093", 'paleviolet-red', rgb(0.86, 0.44, 0.58)).
latex_colour('Pansy purple', "#78184A", pansypurple, rgb(0.47, 0.09, 0.29)).
latex_colour('Papaya whip', "#FFEFD5", papayawhip, rgb(1.0, 0.94, 0.84)).
latex_colour('Paris Green', "#50C878", parisgreen, rgb(0.31, 0.78, 0.47)).
latex_colour('Pastel blue', "#AEC6CF", pastelblue, rgb(0.68, 0.78, 0.81)).
latex_colour('Pastel brown', "#836953", pastelbrown, rgb(0.51, 0.41, 0.33)).
latex_colour('Pastel gray', "#CFCFC4", pastelgray, rgb(0.81, 0.81, 0.77)).
latex_colour('Pastel green', "#77DD77", pastelgreen, rgb(0.47, 0.87, 0.47)).
latex_colour('Pastel magenta', "#F49AC2", pastelmagenta, rgb(0.96, 0.6, 0.76)).
latex_colour('Pastel orange', "#FFB347", pastelorange, rgb(1.0, 0.7, 0.28)).
latex_colour('Pastel pink', "#FFD1DC", pastelpink, rgb(1.0, 0.82, 0.86)).
latex_colour('Pastel purple', "#B39EB5", pastelpurple, rgb(0.7, 0.62, 0.71)).
latex_colour('Pastel red', "#FF6961", pastelred, rgb(1.0, 0.41, 0.38)).
latex_colour('Pastel violet', "#CB99C9", pastelviolet, rgb(0.8, 0.6, 0.79)).
latex_colour('Pastel yellow', "#FDFD96", pastelyellow, rgb(0.99, 0.99, 0.59)).
latex_colour('Patriarch', "#800080", patriarch, rgb(0.5, 0.0, 0.5)).
latex_colour('Payne\\\'s grey', "#40404F", 'payne\\\'sgrey', rgb(0.25, 0.25, 0.28)).
latex_colour('Peach', "#FFE5B4", peach, rgb(1.0, 0.9, 0.71)).
latex_colour('Peach-orange', "#FFCC99", 'peach-orange', rgb(1.0, 0.8, 0.6)).
latex_colour('Peach puff', "#FFDAB9", peachpuff, rgb(1.0, 0.85, 0.73)).
latex_colour('Peach-yellow', "#FADFAD", 'peach-yellow', rgb(0.98, 0.87, 0.68)).
latex_colour('Pear', "#D1E231", pear, rgb(0.82, 0.89, 0.19)).
latex_colour('Pearl', "#F0EAD6", pearl, rgb(0.94, 0.92, 0.84)).
latex_colour('Peridot', "#E6E200", peridot, rgb(0.9, 0.89, 0.0)).
latex_colour('Periwinkle', "#CCCCFF", periwinkle, rgb(0.8, 0.8, 1.0)).
latex_colour('Persian blue', "#1C39BB", persianblue, rgb(0.11, 0.22, 0.73)).
latex_colour('Persian green', "#00A693", persiangreen, rgb(0.0, 0.65, 0.58)).
latex_colour('Persian indigo', "#32127A", persianindigo, rgb(0.2, 0.07, 0.48)).
latex_colour('Persian orange', "#D99058", persianorange, rgb(0.85, 0.56, 0.35)).
latex_colour('Peru', "#CD853F", peru, rgb(0.8, 0.52, 0.25)).
latex_colour('Persian pink', "#F77FBE", persianpink, rgb(0.97, 0.5, 0.75)).
latex_colour('Persian plum', "#701C1C", persianplum, rgb(0.44, 0.11, 0.11)).
latex_colour('Persian red', "#CC3333", persianred, rgb(0.8, 0.2, 0.2)).
latex_colour('Persian rose', "#FE28A2", persianrose, rgb(1.0, 0.16, 0.64)).
latex_colour('Persimmon', "#EC5800", persimmon, rgb(0.93, 0.35, 0.0)).
latex_colour('Phlox', "#DF00FF", phlox, rgb(0.87, 0.0, 1.0)).
latex_colour('Phthalo blue', "#000F89", phthaloblue, rgb(0.0, 0.06, 0.54)).
latex_colour('Phthalo green', "#123524", phthalogreen, rgb(0.07, 0.21, 0.14)).
latex_colour('Piggy pink', "#FDDDE6", piggypink, rgb(0.99, 0.87, 0.9)).
latex_colour('Pine green', "#01796F", pinegreen, rgb(0.0, 0.47, 0.44)).
latex_colour('Pink', "#FFC0CB", pink, rgb(1.0, 0.75, 0.8)).
latex_colour('Pink-orange', "#FF9966", 'pink-orange', rgb(1.0, 0.6, 0.4)).
latex_colour('Pink pearl', "#E7ACCF", pinkpearl, rgb(0.91, 0.67, 0.81)).
latex_colour('Pink Sherbet', "#F78FA7", pinksherbet, rgb(0.97, 0.56, 0.65)).
latex_colour('Pistachio', "#93C572", pistachio, rgb(0.58, 0.77, 0.45)).
latex_colour('Platinum', "#E5E4E2", platinum, rgb(0.9, 0.89, 0.89)).
latex_colour('Plum (traditional)', "#8E4585", 'plum(traditional)', rgb(0.56, 0.27, 0.52)).
latex_colour('Plum (web)', "#DDA0DD", 'plum(web)', rgb(0.8, 0.6, 0.8)).
latex_colour('Portland Orange', "#FF5A36", portlandorange, rgb(1.0, 0.35, 0.21)).
latex_colour('Powder blue (web)', "#B0E0E6", 'powderblue(web)', rgb(0.69, 0.88, 0.9)).
latex_colour('Princeton orange', "#FF8F00", princetonorange, rgb(1.0, 0.56, 0.0)).
latex_colour('Prune', "#701C1C", prune, rgb(0.44, 0.11, 0.11)).
latex_colour('Prussian blue', "#003153", prussianblue, rgb(0.0, 0.19, 0.33)).
latex_colour('Psychedelic purple', "#DF00FF", psychedelicpurple, rgb(0.87, 0.0, 1.0)).
latex_colour('Puce', "#CC8899", puce, rgb(0.8, 0.53, 0.6)).
latex_colour('Pumpkin', "#FF7518", pumpkin, rgb(1.0, 0.46, 0.09)).
latex_colour('Purple (HTML/CSS)', "#800080", 'purple(html/css)', rgb(0.5, 0.0, 0.5)).
latex_colour('Purple (Munsell)', "#9F00C5", 'purple(munsell)', rgb(0.62, 0.0, 0.77)).
latex_colour('Purple (X11)', "#A020F0", 'purple(x11)', rgb(0.63, 0.36, 0.94)).
latex_colour('Purple Heart', "#69359C", purpleheart, rgb(0.41, 0.21, 0.61)).
latex_colour('Purple mountain majesty', "#9678B6", purplemountainmajesty, rgb(0.59, 0.47, 0.71)).
latex_colour('Purple pizzazz', "#FE4EDA", purplepizzazz, rgb(1.0, 0.31, 0.85)).
latex_colour('Purple taupe', "#50404D", purpletaupe, rgb(0.31, 0.25, 0.3)).
latex_colour('Radical Red', "#FF355E", radicalred, rgb(1.0, 0.21, 0.37)).
latex_colour('Raspberry', "#E30B5D", raspberry, rgb(0.89, 0.04, 0.36)).
latex_colour('Raspberry glace', "#915F6D", raspberryglace, rgb(0.57, 0.37, 0.43)).
latex_colour('Raspberry pink', "#E25098", raspberrypink, rgb(0.89, 0.31, 0.61)).
latex_colour('Raspberry rose', "#B3446C", raspberryrose, rgb(0.7, 0.27, 0.42)).
latex_colour('Raw umber', "#826644", rawumber, rgb(0.51, 0.4, 0.27)).
latex_colour('Razzle dazzle rose', "#FF33CC", razzledazzlerose, rgb(1.0, 0.2, 0.8)).
latex_colour('Razzmatazz', "#E3256B", razzmatazz, rgb(0.89, 0.15, 0.42)).
latex_colour('Red', "#FF0000", red, rgb(1.0, 0.0, 0.0)).
latex_colour('Red (Munsell)', "#F2003C", 'red(munsell)', rgb(0.95, 0.0, 0.24)).
latex_colour('Red (NCS)', "#C40233", 'red(ncs)', rgb(0.77, 0.01, 0.2)).
latex_colour('Red (pigment)', "#ED1C24", 'red(pigment)', rgb(0.93, 0.11, 0.14)).
latex_colour('Red (RYB)', "#FE2712", 'red(ryb)', rgb(1.0, 0.15, 0.07)).
latex_colour('Red-brown', "#A52A2A", 'red-brown', rgb(0.65, 0.16, 0.16)).
latex_colour('Red-violet', "#C71585", 'red-violet', rgb(0.78, 0.08, 0.52)).
latex_colour('Redwood', "#AB4E52", redwood, rgb(0.67, 0.31, 0.32)).
latex_colour('Regalia', "#522D80", regalia, rgb(0.32, 0.18, 0.5)).
latex_colour('Rich black', "#004040", richblack, rgb(0.0, 0.25, 0.25)).
latex_colour('Rich brilliant lavender', "#F1A7FE", richbrilliantlavender, rgb(0.95, 0.65, 1.0)).
latex_colour('Rich carmine', "#D70040", richcarmine, rgb(0.84, 0.0, 0.25)).
latex_colour('Rich electric blue', "#0892D0", richelectricblue, rgb(0.03, 0.57, 0.82)).
latex_colour('Rich lavender', "#A76BCF", richlavender, rgb(0.67, 0.38, 0.8)).
latex_colour('Rich lilac', "#B666D2", richlilac, rgb(0.71, 0.4, 0.82)).
latex_colour('Rich maroon', "#B03060", richmaroon, rgb(0.69, 0.19, 0.38)).
latex_colour('Rifle green', "#414833", riflegreen, rgb(0.25, 0.28, 0.2)).
latex_colour('Robin egg blue', "#00CCCC", robineggblue, rgb(0.0, 0.8, 0.8)).
latex_colour('Rose', "#FF007F", rose, rgb(1.0, 0.0, 0.5)).
latex_colour('Rose bonbon', "#F9429E", rosebonbon, rgb(0.98, 0.26, 0.62)).
latex_colour('Rose ebony', "#674846", roseebony, rgb(0.4, 0.3, 0.28)).
latex_colour('Rose gold', "#B76E79", rosegold, rgb(0.72, 0.43, 0.47)).
latex_colour('Rose madder', "#E32636", rosemadder, rgb(0.89, 0.15, 0.21)).
latex_colour('Rose pink', "#FF66CC", rosepink, rgb(1.0, 0.4, 0.8)).
latex_colour('Rose quartz', "#AA98A9", rosequartz, rgb(0.67, 0.6, 0.66)).
latex_colour('Rose taupe', "#905D5D", rosetaupe, rgb(0.56, 0.36, 0.36)).
latex_colour('Rose vale', "#AB4E52", rosevale, rgb(0.67, 0.31, 0.32)).
latex_colour('Rosewood', "#65000B", rosewood, rgb(0.4, 0.0, 0.04)).
latex_colour('Rosso corsa', "#D40000", rossocorsa, rgb(0.83, 0.0, 0.0)).
latex_colour('Rosy brown', "#BC8F8F", rosybrown, rgb(0.74, 0.56, 0.56)).
latex_colour('Royal azure', "#0038A8", royalazure, rgb(0.0, 0.22, 0.66)).
latex_colour('Royal blue (traditional)', "#002366", 'royalblue(traditional)', rgb(0.0, 0.14, 0.4)).
latex_colour('Royal blue (web)', "#4169E1", 'royalblue(web)', rgb(0.25, 0.41, 0.88)).
latex_colour('Royal fuchsia', "#CA2C92", royalfuchsia, rgb(0.79, 0.17, 0.57)).
latex_colour('Royal purple', "#7851A9", royalpurple, rgb(0.47, 0.32, 0.66)).
latex_colour('Ruby', "#E0115F", ruby, rgb(0.88, 0.07, 0.37)).
latex_colour('Ruddy', "#FF0028", ruddy, rgb(1.0, 0.0, 0.16)).
latex_colour('Ruddy brown', "#BB6528", ruddybrown, rgb(0.73, 0.4, 0.16)).
latex_colour('Ruddy pink', "#E18E96", ruddypink, rgb(0.88, 0.56, 0.59)).
latex_colour('Rufous', "#A81C07", rufous, rgb(0.66, 0.11, 0.03)).
latex_colour('Russet', "#80461B", russet, rgb(0.5, 0.27, 0.11)).
latex_colour('Rust', "#B7410E", rust, rgb(0.72, 0.25, 0.05)).
latex_colour('Sacramento State green', "#00563F", sacramentostategreen, rgb(0.0, 0.34, 0.25)).
latex_colour('Saddle brown', "#8B4513", saddlebrown, rgb(0.55, 0.27, 0.07)).
latex_colour('Safety orange (blaze orange)', "#FF6700", 'safetyorange(blazeorange)', rgb(1.0, 0.4, 0.0)).
latex_colour('Saffron', "#F4C430", saffron, rgb(0.96, 0.77, 0.19)).
latex_colour('St. Patrick\\\'s blue', "#23297A", 'st.patrick\\\'sblue', rgb(0.14, 0.16, 0.48)).
latex_colour('Salmon', "#FF8C69", salmon, rgb(1.0, 0.55, 0.41)).
latex_colour('Salmon pink', "#FF91A4", salmonpink, rgb(1.0, 0.57, 0.64)).
latex_colour('Sand', "#C2B280", sand, rgb(0.76, 0.7, 0.5)).
latex_colour('Sand dune', "#967117", sanddune, rgb(0.59, 0.44, 0.09)).
latex_colour('Sandstorm', "#ECD540", sandstorm, rgb(0.93, 0.84, 0.25)).
latex_colour('Sandy brown', "#F4A460", sandybrown, rgb(0.96, 0.64, 0.38)).
latex_colour('Sandy taupe', "#967117", sandytaupe, rgb(0.59, 0.44, 0.09)).
latex_colour('Sangria', "#92000A", sangria, rgb(0.57, 0.0, 0.04)).
latex_colour('Sap green', "#507D2A", sapgreen, rgb(0.31, 0.49, 0.16)).
latex_colour('Sapphire', "#082567", sapphire, rgb(0.03, 0.15, 0.4)).
latex_colour('Satin sheen gold', "#CBA135", satinsheengold, rgb(0.8, 0.63, 0.21)).
latex_colour('Scarlet', "#FF2000", scarlet, rgb(1.0, 0.13, 0.0)).
latex_colour('School bus yellow', "#FFD800", schoolbusyellow, rgb(1.0, 0.85, 0.0)).
latex_colour('Screamin\\\' Green', "#76FF7A", 'screamin\\\'green', rgb(0.46, 1.0, 0.44)).
latex_colour('Sea green', "#2E8B57", seagreen, rgb(0.18, 0.55, 0.34)).
latex_colour('Seal brown', "#321414", sealbrown, rgb(0.2, 0.08, 0.08)).
latex_colour('Seashell', "#FFF5EE", seashell, rgb(1.0, 0.96, 0.93)).
latex_colour('Selective yellow', "#FFBA00", selectiveyellow, rgb(1.0, 0.73, 0.0)).
latex_colour('Sepia', "#704214", sepia, rgb(0.44, 0.26, 0.08)).
latex_colour('Shadow', "#8A795D", shadow, rgb(0.54, 0.47, 0.36)).
latex_colour('Shamrock green', "#009E60", shamrockgreen, rgb(0.0, 0.62, 0.38)).
latex_colour('Shocking pink', "#FC0FC0", shockingpink, rgb(0.99, 0.06, 0.75)).
latex_colour('Sienna', "#882D17", sienna, rgb(0.53, 0.18, 0.09)).
latex_colour('Silver', "#C0C0C0", silver, rgb(0.75, 0.75, 0.75)).
latex_colour('Sinopia', "#CB410B", sinopia, rgb(0.8, 0.25, 0.04)).
latex_colour('Skobeloff', "#007474", skobeloff, rgb(0.0, 0.48, 0.45)).
latex_colour('Sky blue', "#87CEEB", skyblue, rgb(0.53, 0.81, 0.92)).
latex_colour('Sky magenta', "#CF71AF", skymagenta, rgb(0.81, 0.44, 0.69)).
latex_colour('Slate blue', "#6A5ACD", slateblue, rgb(0.42, 0.35, 0.8)).
latex_colour('Slate gray', "#708090", slategray, rgb(0.44, 0.5, 0.56)).
latex_colour('Smalt (Dark powder blue)', "#003399", 'smalt(darkpowderblue)', rgb(0.0, 0.2, 0.6)).
latex_colour('Smokey topaz', "#933D41", smokeytopaz, rgb(0.58, 0.25, 0.03)).
latex_colour('Smoky black', "#100C08", smokyblack, rgb(0.06, 0.05, 0.03)).
latex_colour('Snow', "#FFFAFA", snow, rgb(1.0, 0.98, 0.98)).
latex_colour('Spiro Disco Ball', "#0FC0FC", spirodiscoball, rgb(0.06, 0.75, 0.99)).
latex_colour('Splashed white', "#FEFDFF", splashedwhite, rgb(1.0, 0.99, 1.0)).
latex_colour('Spring bud', "#A7FC00", springbud, rgb(0.65, 0.99, 0.0)).
latex_colour('Spring green', "#00FF7F", springgreen, rgb(0.0, 1.0, 0.5)).
latex_colour('Steel blue', "#4682B4", steelblue, rgb(0.27, 0.51, 0.71)).
latex_colour('Stil de grain yellow', "#FADA5E", stildegrainyellow, rgb(0.98, 0.85, 0.37)).
latex_colour('Straw', "#E4D96F", straw, rgb(0.89, 0.85, 0.44)).
latex_colour('Sunglow', "#FFCC33", sunglow, rgb(1.0, 0.8, 0.2)).
latex_colour('Sunset', "#FAD6A5", sunset, rgb(0.98, 0.84, 0.65)).
latex_colour('Tan', "#D2B48C", tan, rgb(0.82, 0.71, 0.55)).
latex_colour('Tangelo', "#F94D00", tangelo, rgb(0.98, 0.3, 0.0)).
latex_colour('Tangerine', "#F28500", tangerine, rgb(0.95, 0.52, 0.0)).
latex_colour('Tangerine yellow', "#FFCC00", tangerineyellow, rgb(1.0, 0.8, 0.0)).
latex_colour('Taupe', "#483C32", taupe, rgb(0.28, 0.24, 0.2)).
latex_colour('Taupe gray', "#8B8589", taupegray, rgb(0.55, 0.52, 0.54)).
latex_colour('Tea green', "#D0F0C0", teagreen, rgb(0.82, 0.94, 0.75)).
latex_colour('Tea rose (orange)', "#F88379", 'tearose(orange)', rgb(0.97, 0.51, 0.47)).
latex_colour('Tea rose (rose)', "#F4C2C2", 'tearose(rose)', rgb(0.96, 0.76, 0.76)).
latex_colour('Teal', "#008080", teal, rgb(0.0, 0.5, 0.5)).
latex_colour('Teal blue', "#367588", tealblue, rgb(0.21, 0.46, 0.53)).
latex_colour('Teal green', "#006D5B", tealgreen, rgb(0.0, 0.51, 0.5)).
latex_colour('Tenné (Tawny)', "#CD5700", 'tenné(tawny)', rgb(0.8, 0.34, 0.0)).
latex_colour('Terra cotta', "#E2725B", terracotta, rgb(0.89, 0.45, 0.36)).
latex_colour('Thistle', "#D8BFD8", thistle, rgb(0.85, 0.75, 0.85)).
latex_colour('Thulian pink', "#DE6FA1", thulianpink, rgb(0.87, 0.44, 0.63)).
latex_colour('Tickle Me Pink', "#FC89AC", ticklemepink, rgb(0.99, 0.54, 0.67)).
latex_colour('Tiffany Blue', "#0ABAB5", tiffanyblue, rgb(0.04, 0.73, 0.71)).
latex_colour('Tiger\\\'s eye', "#E08D3C", 'tiger\\\'seye', rgb(0.88, 0.55, 0.24)).
latex_colour('Timberwolf', "#DBD7D2", timberwolf, rgb(0.86, 0.84, 0.82)).
latex_colour('Titanium yellow', "#EEE600", titaniumyellow, rgb(0.93, 0.9, 0.0)).
latex_colour('Tomato', "#FF6347", tomato, rgb(1.0, 0.39, 0.28)).
latex_colour('Toolbox', "#746CC0", toolbox, rgb(0.45, 0.42, 0.75)).
latex_colour('Tractor red', "#FD0E35", tractorred, rgb(0.99, 0.05, 0.21)).
latex_colour('Trolley Grey', "#808080", trolleygrey, rgb(0.5, 0.5, 0.5)).
latex_colour('Tropical rain forest', "#00755E", tropicalrainforest, rgb(0.0, 0.46, 0.37)).
latex_colour('True Blue', "#0073CF", trueblue, rgb(0.0, 0.45, 0.81)).
latex_colour('Tufts Blue', "#417DC1", tuftsblue, rgb(0.28, 0.57, 0.81)).
latex_colour('Tumbleweed', "#DEAA88", tumbleweed, rgb(0.87, 0.67, 0.53)).
latex_colour('Turkish rose', "#B57281", turkishrose, rgb(0.71, 0.45, 0.51)).
latex_colour('Turquoise', "#30D5C8", turquoise, rgb(0.19, 0.84, 0.78)).
latex_colour('Turquoise blue', "#00FFEF", turquoiseblue, rgb(0.0, 1.0, 0.94)).
latex_colour('Turquoise green', "#A0D6B4", turquoisegreen, rgb(0.63, 0.84, 0.71)).
latex_colour('Tuscan red', "#823535", tuscanred, rgb(0.51, 0.21, 0.21)).
latex_colour('Twilight lavender', "#8A496B", twilightlavender, rgb(0.54, 0.29, 0.42)).
latex_colour('Tyrian purple', "#66023C", tyrianpurple, rgb(0.4, 0.01, 0.24)).
latex_colour('UA blue', "#0033AA", uablue, rgb(0.0, 0.2, 0.67)).
latex_colour('UA red', "#D9004C", uared, rgb(0.85, 0.0, 0.3)).
latex_colour('Ube', "#8878C3", ube, rgb(0.53, 0.47, 0.76)).
latex_colour('UCLA Blue', "#536895", uclablue, rgb(0.33, 0.41, 0.58)).
latex_colour('UCLA Gold', "#FFB300", uclagold, rgb(1.0, 0.7, 0.0)).
latex_colour('UFO Green', "#3CD070", ufogreen, rgb(0.24, 0.82, 0.44)).
latex_colour('Ultramarine', "#120A8F", ultramarine, rgb(0.07, 0.04, 0.56)).
latex_colour('Ultramarine blue', "#4166F5", ultramarineblue, rgb(0.25, 0.4, 0.96)).
latex_colour('Ultra pink', "#FF6FFF", ultrapink, rgb(1.0, 0.44, 1.0)).
latex_colour('Umber', "#635147", umber, rgb(0.39, 0.32, 0.28)).
latex_colour('United Nations blue', "#5B92E5", unitednationsblue, rgb(0.36, 0.57, 0.9)).
latex_colour('Unmellow Yellow', "#FFFF66", unmellowyellow, rgb(1.0, 1.0, 0.4)).
latex_colour('UP Forest green', "#014421", upforestgreen, rgb(0.0, 0.27, 0.13)).
latex_colour('UP Maroon', "#7B1113", upmaroon, rgb(0.48, 0.07, 0.07)).
latex_colour('Upsdell red', "#AE2029", upsdellred, rgb(0.68, 0.09, 0.13)).
latex_colour('Urobilin', "#E1AD21", urobilin, rgb(0.88, 0.68, 0.13)).
latex_colour('USC Cardinal', "#990000", usccardinal, rgb(0.6, 0.0, 0.0)).
latex_colour('USC Gold', "#FFCC00", uscgold, rgb(1.0, 0.8, 0.0)).
latex_colour('Utah Crimson', "#D3003F", utahcrimson, rgb(0.83, 0.0, 0.25)).
latex_colour('Vanilla', "#F3E5AB", vanilla, rgb(0.95, 0.9, 0.67)).
latex_colour('Vegas gold', "#C5B358", vegasgold, rgb(0.77, 0.7, 0.35)).
latex_colour('Venetian red', "#C80815", venetianred, rgb(0.78, 0.03, 0.08)).
latex_colour('Verdigris', "#43B3AE", verdigris, rgb(0.26, 0.7, 0.68)).
latex_colour('Vermilion', "#E34234", vermilion, rgb(0.89, 0.26, 0.2)).
latex_colour('Veronica', "#A020F0", veronica, rgb(0.63, 0.36, 0.94)).
latex_colour('Violet', "#8F00FF", violet, rgb(0.56, 0.0, 1.0)).
latex_colour('Violet (color wheel)', "#7F00FF", 'violet(colorwheel)', rgb(0.5, 0.0, 1.0)).
latex_colour('Violet (RYB)', "#8601AF", 'violet(ryb)', rgb(0.53, 0.0, 0.69)).
latex_colour('Violet (web)', "#EE82EE", 'violet(web)', rgb(0.93, 0.51, 0.93)).
latex_colour('Viridian', "#40826D", viridian, rgb(0.25, 0.51, 0.43)).
latex_colour('Vivid auburn', "#922724", vividauburn, rgb(0.58, 0.15, 0.14)).
latex_colour('Vivid burgundy', "#9F1D35", vividburgundy, rgb(0.62, 0.11, 0.21)).
latex_colour('Vivid cerise', "#DA1D81", vividcerise, rgb(0.85, 0.11, 0.51)).
latex_colour('Vivid tangerine', "#FFA089", vividtangerine, rgb(1.0, 0.63, 0.54)).
latex_colour('Vivid violet', "#9F00FF", vividviolet, rgb(0.62, 0.0, 1.0)).
latex_colour('Warm black', "#004242", warmblack, rgb(0.0, 0.26, 0.26)).
latex_colour('Wenge', "#645452", wenge, rgb(0.39, 0.33, 0.32)).
latex_colour('Wheat', "#F5DEB3", wheat, rgb(0.96, 0.87, 0.7)).
latex_colour('White', "#FFFFFF", white, rgb(1.0, 1.0, 1.0)).
latex_colour('White smoke', "#F5F5F5", whitesmoke, rgb(0.96, 0.96, 0.96)).
latex_colour('Wild blue yonder', "#A2ADD0", wildblueyonder, rgb(0.64, 0.68, 0.82)).
latex_colour('Wild Strawberry', "#FF43A4", wildstrawberry, rgb(1.0, 0.26, 0.64)).
latex_colour('Wild Watermelon', "#FC6C85", wildwatermelon, rgb(0.99, 0.42, 0.52)).
latex_colour('Wisteria', "#C9A0DC", wisteria, rgb(0.79, 0.63, 0.86)).
latex_colour('Xanadu', "#738678", xanadu, rgb(0.45, 0.53, 0.47)).
latex_colour('Yale Blue', "#0F4D92", yaleblue, rgb(0.06, 0.3, 0.57)).
latex_colour('Yellow', "#FFFF00", yellow, rgb(1.0, 1.0, 0.0)).
latex_colour('Yellow (Munsell)', "#EFCC00", 'yellow(munsell)', rgb(0.94, 0.8, 0.0)).
latex_colour('Yellow (NCS)', "#FFD300", 'yellow(ncs)', rgb(1.0, 0.83, 0.0)).
latex_colour('Yellow (process)', "#FFEF00", 'yellow(process)', rgb(1.0, 0.94, 0.0)).
latex_colour('Yellow (RYB)', "#FEFE33", 'yellow(ryb)', rgb(1.0, 1.0, 0.2)).
latex_colour('Yellow-green', "#9ACD32", 'yellow-green', rgb(0.6, 0.8, 0.2)).
latex_colour('Zaffre', "#0014A8", zaffre, rgb(0.0, 0.08, 0.66)).
latex_colour('Zinnwaldite brown', "#2C1608", zinnwalditebrown, rgb(0.17, 0.09, 0.03)).
